/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics;

import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.VertexBuffer;
import jpcsp.graphics.VertexInfo;

public class VertexArray {
    private int id = -1;
    private int vtype;
    private VertexBuffer vertexBuffer;
    private int stride;
    private boolean pendingReload = false;

    public VertexArray(int vtype, VertexBuffer vertexBuffer, int stride) {
        this.vtype = vtype & 0x9DDFFF;
        this.vertexBuffer = vertexBuffer;
        this.stride = stride;
    }

    public boolean bind(IRenderingEngine re) {
        boolean needSetDataPointers = this.pendingReload;
        this.pendingReload = false;
        if (this.id == -1) {
            this.id = re.genVertexArray();
            needSetDataPointers = true;
        }
        re.bindVertexArray(this.id);
        return needSetDataPointers;
    }

    public void delete(IRenderingEngine re) {
        re.deleteVertexArray(this.id);
        this.id = -1;
    }

    public boolean isMatching(int vtype, VertexBuffer vertexBuffer, int address, int stride) {
        if (this.vertexBuffer != vertexBuffer || this.stride != stride) {
            return false;
        }
        if (this.vtype != (vtype & 0x9DDFFF)) {
            return false;
        }
        return vertexBuffer.getBufferOffset(address) % stride == 0;
    }

    public int getVertexOffset(int address) {
        return this.vertexBuffer.getBufferOffset(address) / this.stride;
    }

    public VertexBuffer getVertexBuffer() {
        return this.vertexBuffer;
    }

    public void forceReload() {
        this.pendingReload = true;
    }

    public String toString() {
        VertexInfo vinfo = new VertexInfo();
        vinfo.processType(this.vtype);
        return String.format("VertexArray[%s, stride %d, id %d, %s]", vinfo, this.stride, this.id, this.vertexBuffer);
    }
}

